<div class="user-dashboard">
    <div class="container">
        <div class="row">
            <div class="col-6"> 
                <h3>Input Classifications</h3>
            </div>
            <div class="col-6" style="text-align: right;"> 
                <button class="btn-save" onclick="addform()">New</button>
                <button class="btn-save" onclick="list()">Refresh</button>
            </div>
            <div class="col-xl-12 col-lg-12">
                <table id="listTable" class="table" style="width:100%">
                    <thead>
                        <tr>
                            <th style="width:150px">Code</th>
                            <th>Classifications</th>
                            <th>From CGPA</th>
                            <th>To CGPA</th>
                            <th style="width:50px">Status</th>
                            <th style="width:100px"></th>
                        </tr>
                    </thead>                                     
                    <tbody id="tbl_content">
                        <tr>
                            <td colspan='4'>
                                <?php echo loadingText("Loading Input Classifications");?>
                            </td>
                        </tr>
                    </tbody>
                </table>
            </div>
        </div>
    </div>                                                         
</div>

<div class="modal fade" id="confirmationtoadd" tabindex="-1" aria-labelledby="exampleModalLabel" aria-hidden="true" data-backdrop="static">
    <div class="modal-dialog modal-dialog-centered">
        <div class="modal-content">
            <div class="modal-header">
                <h5 class="modal-title" id="exampleModalLabel">New Classifications</h5>
                <button type="button" class="btn-close" data-dismiss="modal"></button>
            </div>
            <div class="modal-body">
             <form id="frm_create" name="frm_create" method="post" enctype="multipart/form-data" autocomplete="off">
                <div class="row">
                <span id="ErrCommon"></span>
                    <div class="col-6">
                        <label class="form-label">Code</label><span style='color:red'>*</span>
                        <input class="form-control form-control-sm" type="text" id="Code" name="Code" placeholder="Code" value="" onkeypress="clearInput('Code')">
                        <span id="ErrCode" class="error_msg" style="color: red;"></span>
                    </div>
                    <div class="col-12">
                        <label class="form-label">Classification</label><span style='color:red'>*</span>
                         <input class="form-control form-control-sm" type="text" name="Classification" id="Classification" placeholder="Classification" onkeypress="clearInput('Classification')">
                        <span id="ErrClassification" class="error_msg" style="color: red;"></span>
                    </div>
                   <div class="col-sm-12">
                        <label class="form-label">CGPA Range <span style='color:red'>*</span></label>
                        <div class="input-group">
                        <span class="input-group-text" id="basic-addon1">From</span>
                            <input type="text" name="FromCGPA" value="" id="FromCGPA" class="form-control form-control-sm" placeholder="CGPA" onkeypress="clearInput('FromCGPA');$('#ErrCGPARange').html('');">
                            <div class="input-group-prepend">
                                <span class="input-group-text" id="basic-addon1">To</span>
                        </div>
                        <input type="text" name="ToCGPA" id="ToCGPA" class="form-control form-control-sm" placeholder="CGPA" onkeypress="clearInput('ToCGPA');$('#ErrCGPARange').html('');">
                    </div> 
                    <span id="ErrCGPARange" class="error_msg" style="color: red;"></span>
                    </div>
                    <div class="col-12">
                        <label class="form-label">Remarks</label>
                        <input class="form-control form-control-sm" type="text" id="Remarks" name="Remarks" placeholder="Remarks" value="" onkeypress="clearInput('Remarks')">
                        <span id="ErrRemarks" class="error_msg" style="color: red;"></span>
                    </div>
                </div>
             </form>
            </div>
            <div class="modal-footer">
                 <button type="button" data-dismiss="modal" class="btn-cancel">Cancel</button>
                 <button type="button" href="javascript:void(0)" onclick="add()" class="btn-save">Save</button>
            </div>
        </div>                                                                                                                     
    </div>
</div>
                                                                                                            
<div class="modal fade" id="confirmationtoedit" tabindex="-1" aria-labelledby="exampleModalLabel" aria-hidden="true" data-backdrop="static">
    <div class="modal-dialog modal-dialog-centered">
        <div class="modal-content">
            <div class="modal-header">
                <h5 class="modal-title" id="exampleModalLabel">Edit Classification</h5>
                <button type="button" class="btn-close" data-dismiss="modal"></button>
            </div>
            <div class="modal-body">
             <form id="frm_edit" name="frm_edit" method="post" enctype="multipart/form-data" autocomplete="off">
                <input type="hidden" name="ID" id="editID">
                <div class="row">
                <span id="ErreditCommon"></span>
                    <div class="col-6">
                        <label class="form-label">Code</label>
                        <input class="form-control" type="text" readonly="readonly" id="editCode" name="Code" placeholder="Code" value="" onkeypress="clearInput('editCode')">
                        <span id="ErreditCode" class="error_msg" style="color: red;"></span>
                    </div>
                     <div class="col-12">
                        <label class="form-label">Classification</label><span style='color:red'>*</span>
                         <input class="form-control form-control-sm" type="text" name="Classification" id="editClassification" placeholder="Classification" value="" onkeypress="clearInput('editClassification')">
                        <span id="ErreditClassification" class="error_msg" style="color: red;"></span>
                    </div>
                   <div class="col-sm-12">
                        <label class="form-label">CGPA Range <span style='color:red'>*</span></label>
                        <div class="input-group">
                        <span class="input-group-text" id="basic-addon1">From</span>
                            <input type="text" name="FromCGPA" value="" id="editFromCGPA" class="form-control form-control-sm" placeholder="CGPA" onkeypress="clearInput('editFromCGPA');$('#ErreditCGPARange').html('');">
                            <div class="input-group-prepend">
                                <span class="input-group-text" id="basic-addon1">To</span>
                        </div>
                        <input type="text" name="ToCGPA" id="editToCGPA" class="form-control form-control-sm" placeholder="CGPA" onkeypress="clearInput('editToCGPA');$('#ErreditCGPARange').html('');">
                    </div> 
                    <span id="ErreditCGPARange" class="error_msg" style="color: red;"></span>
                    </div>
                    <div class="col-sm-6">
                        <label class="form-label">Status</label>
                        <select name="Status" id="editStatus" class="form-select form-select-sm">
                            <option value="1">Active</option>
                            <option value="0">Deactive</option>
                        </select>
                    </div>
                    <div class="col-12">
                        <label class="form-label">Remarks</label>
                        <input class="form-control form-control-sm" type="text" id="editRemarks" name="Remarks" placeholder="Remarks" value="" onkeypress="clearInput('editRemarks')">
                        <span id="ErreditRemarks" class="error_msg" style="color: red;"></span>
                    </div>
                </div>
             </form>
            </div>
            <div class="modal-footer">
                <button type="button" data-dismiss="modal" class="btn-cancel">Cancel</button>
                 <button type="button" href="javascript:void(0)" onclick="edit()" class="btn-save">Update</button>
            </div>
        </div>                                                                                                                     
    </div>
</div>

<div class="modal fade" id="confirmationtoview" tabindex="-1" aria-labelledby="exampleModalLabel" aria-hidden="true" data-backdrop="static">
    <div class="modal-dialog modal-dialog-centered">
        <div class="modal-content">
            <div class="modal-header">
                <h5 class="modal-title" id="exampleModalLabel">View Classification</h5>
                <button type="button" class="btn-close" data-dismiss="modal"></button>
            </div>
            <div class="modal-body">                                                        
                <div class="row">
                    <div class="col-sm-6">
                        <div style="font-weight: bold;">Code</div>
                        <div id="viewCode"></div>
                    </div>
                    <div class="col-sm-12">
                        <div style="font-weight: bold;">Classification</div>
                        <div id="viewClassification"></div>
                    </div>
                    <div class="col-sm-12">
                        <div style="font-weight: bold;">From CGPA</div>
                        <div id="viewFromCGPARange"></div>
                    </div>
                    <div class="col-sm-12">
                        <div style="font-weight: bold;">To CGPA</div>
                        <div id="viewToCGPARange"></div>
                    </div>
                    <div class="col-sm-12">
                        <div style="font-weight: bold;">Remarks</div>
                        <div id="viewRemarks"></div>
                    </div>
                    <div class="col-sm-6">
                        <div style="font-weight: bold;">Status</div>
                        <div id="viewStatus"></div>
                    </div>
                    <div class="col-sm-6">
                        <div style="font-weight: bold;">Created On</div>
                        <div id="viewCreatedOn"></div>
                    </div>
                </div>
            </div>
            <div class="modal-footer"> 
                 <button type="button" data-dismiss="modal" class="btn-cancel">Close</button>
            </div>
        </div>                                                                                                                     
    </div>
</div>
<div class="modal fade" id="Success" tabindex="-1" aria-labelledby="exampleModalLabel" aria-hidden="true" data-backdrop="static">
    <div class="modal-dialog modal-dialog-centered">
        <div class="modal-content">
            <div class="modal-body" style="text-align: center;">
                <div id="sucess">
                    <img id="Sucess" style="width: 150px;" src="assets/sucess.gif" alt=""/>
                </div>
                <h3 class="title">Success.</h3>  
                 <button type="button" href="javascript:void(0)" onclick="list()" class="btn-save">Continue</button>         
            </div>
        </div>
    </div>
</div>
     
<script>
function list() {
      $('#Success').modal("hide");
       var html = '<tr>'
                + '<td colspan="6" style="text-align: center;background:#fff !important">Loading Academic Years</td>'
                + '</tr>'
      $('#tbl_content').html(html);
    $.post(URL+ "webservice.php?action=l&method=madvl","",function(data){
      var obj = JSON.parse(data);
        if (obj.status=="success") {
            var html = "";
            i=0;
            $.each(obj.data, function (index, data) {
                html += '<tr class="'+((i%2!=0) ? 'rEven' : 'rOdd')+'">'
                            + '<td>' + data.Code + '</td>'
                            + '<td>' + data.Classification + '</td>' 
                            + '<td>' + data.FromCGPA + '</td>' 
                            + '<td>' + data.ToCGPA + '</td>' 
                            + '<td>' + ( (data.Status=="1") ? "<span class='badge bg-success'>Active</span>" : "<span class='badge bg-secondary'>Deactive</span>" ) + '</td>'
                             + '<td style="text-align:right">' 
                                + '<span onclick="editform(\''+data.ID+'\')" class="editLink"  title="Edit Record"><i class="fi fi-rs-pencil"></i></span>&nbsp;&nbsp;'
                               + '<span onclick="viewform(\''+data.ID+'\')" class="viewLink"  title="View Record"><i class="fi fi-rs-web-test"></i></span>&nbsp;&nbsp;'
                               + '<span onclick="openDeleteConfirmation(\''+data.ID+'\',\'r\',\'madvl\',\''+data.InputClassification+'\',\'l\')" class="deleteLink" title="Delete Record"><i class="fi fi-rs-trash"></i></span>'
                               + '</td>'
                             + '</tr>' 
                      + '</tr>';
                      i++;
            });
            if(obj.data.length==0){
            html += '<tr>'
                + '<td colspan="6" style="text-align: center;background:#fff !important">No data found</td>'
                + '</tr>'
            }   
            $('#tbl_content').html(html);
        } else {
             $('#popupcontent').html( error(obj.message));
        }  
    });
}

setTimeout("list()",2000);

function addform(){
     $('#confirmationtoadd').modal("show"); 
     $('#Code').val(""); 
     $('#Classification').val("");                                                                   
     $('#FromCGPA').val(""); 
     $('#ToCGPA').val(""); 
     $('#Remarks').val(""); 
     
     $('#ErrCode').html("");
     $('#ErrClassification').html(""); 
     $('#ErrCGPARange').html(""); 
     $('#ErrRemarks').html("");
    
     $("#Code").removeClass("highlight_error");   
     $("#Classification").removeClass("highlight_error");   
     $("#CGPARange").removeClass("highlight_error");   
     $("#Remarks").removeClass("highlight_error");   
}

function add(){
     var error = 0;
       if ($('#Code').val()==""){
            $('#ErrCode').html("Please enter Code");
            $("#Code").addClass("highlight_error"); 
           error++;
    }  else {
            $("#Code").removeClass("highlight_error"); 
            $('#ErrCode').html(""); 
    }
    if ($('#Division').val()==""){
            $('#ErrDivision').html("Please enter Division");
            $("#Division").addClass("highlight_error"); 
          error++;
    }  else {
            $("#Division").removeClass("highlight_error"); 
            $('#ErrDivision').html(""); 
    }
    if ($('#Classification').val()==""){
            $('#ErrClassification').html("Please enter Classification");
            $("#Classification").addClass("highlight_error"); 
          error++;
    }  else {
            $("#Classification").removeClass("highlight_error"); 
            $('#ErrClassification').html(""); 
    } 
    if ($('#FromCGPA').val()=="") {
            $('#ErrCGPARange').html("Please enter From CGPA");
           $("#FromCGPA").addClass("highlight_error");
           error++;
    }  else {
           if ($('#ToCGPA').val()==""){
            $('#ErrCGPARange').html("Please enter To CGPA");
            $("#ToCGPA").addClass("highlight_error");
            error++;
    }  else {
           $("#ToCGPA").removeClass("highlight_error");
            $('#ErrCGPARange').html("");  
    } 
    }
   
      if(error==0){
        var param = $('#frm_create').serialize();
        $.post(URL+"webservice.php?action=a&method=madvl",param,function(data){
        var obj = JSON.parse(data); 
        if (obj.status=="success") {
             $('#confirmationtoadd').modal("hide"); 
             $('#Success').modal("show");    
        }   else {
            if (obj.div=="") {
                $('#ErrCommon').html(print_inlineError(obj.message));
            } else {
               
            }
        }
    });
   }  
   
}

function editform(ID){
     $('#confirmationtoedit').modal("show"); 
     
     $('#ErreditCode').html("");
     $('#ErreditClassification').html(""); 
     $('#ErreditCGPARange').html(""); 
     $('#ErrRemarks').html("");
     
     $("#editCode").removeClass("highlight_error");   
     $("#editClassification").removeClass("highlight_error");   
     $("#editCGPARange").removeClass("highlight_error");   
     $("#editeditRemarks").removeClass("highlight_error");
      $.post(URL+ "webservice.php?action=g&method=madvl&ID="+ID,"",function(data){
        var obj = JSON.parse(data);
        if (obj.status=="success") {
            var html = "";
            $.each(obj.data, function (index, data) {
                $('#editCode').val(data.Code);
                $('#editID').val(data.ID);
                $('#editClassification').val(data.Classification);
                $('#editCGPARange').val(data.CGPARange);
                $('#editStatus').val(data.Status);
                $('#editRemarks').val(data.Remarks);
            });   
}  
        else {
            if (obj.div=="") {
                $('#ErreditCommon').html(print_inlineError(obj.message));
            } else {
               $("#Erredit"+obj.div).html(obj.message);  
            }
        }
  }); 
}

function edit(ID){
     var error = 0;
    if ($('#editCode').val()==""){
            $('#ErreditCode').html("Please enter Code");
         $("#editCode").addClass("highlight_error");  
          error++;
    }  else {
            $("#editCode").removeClass("highlight_error");  
            $('#ErreditCode').html(""); 
    }
     if ($('#editClassification').val()==""){
            $('#ErreditClassification').html("Please enter Classification");
            $("#editClassification").addClass("highlight_error"); 
         error++;
    }  else {
            $("#editClassification").removeClass("highlight_error"); 
            $('#ErreditClassification').html(""); 
    } 
   if ($('#editFromCGPA').val()=="") {
            $('#ErreditCGPARange').html("Please enter From CGPA");
           $("#editFromCGPA").addClass("highlight_error");
           error++;
    }  else {
           if ($('#editToCGPA').val()==""){
            $('#ErreditCGPARange').html("Please enter To CGPA");
            $("#editToCGPA").addClass("highlight_error");
            error++;
    }  else {
           $("#editToCGPA").removeClass("highlight_error");
            $('#ErreditCGPARange').html("");  
    } 
    } 
     if(error==0){
            var param = $('#frm_edit').serialize();
            $.post(URL+"webservice.php?action=u&method=madvl",param,function(data){
            var obj = JSON.parse(data); 
            if (obj.status=="success") {
                 $('#confirmationtoedit').modal("hide");
                 $('#Success').modal("show");  
            }   else {
                 if (obj.div=="") {
                $('#ErreditCommon').html(print_inlineError(obj.message));
            } else {
                $('#Err'+obj.div).html(obj.message);   
            }
            }
        });
       } 
}

function viewform(ID){
     $('#confirmationtoview').modal("show");
      $.post(URL+ "webservice.php?action=g&method=madvl&ID="+ID,"",function(data){
        var obj = JSON.parse(data);
        if (obj.status=="success") {
            $.each(obj.data, function (index, data) {
                $('#viewCode').html(data.Code=="" ? "&nbsp;" : data.Code);
                $('#viewClassification').html(data.Classification=="" ? "&nbsp;" : data.Classification);
                $('#viewCGPARange').html(data.CGPARange=="" ? "&nbsp;" : data.CGPARange);
                $('#viewRemarks').html(data.Remarks=="" ? "&nbsp;" : data.Remarks);
                $('#viewCreatedOn').html(data.CreatedOn=="" ? "&nbsp;" : data.CreatedOn);
               if(data.Status=="1"){
                $('#viewStatus').html("Active");    
               }
               if(data.Status=="0"){
                $('#viewStatus').html("Deactive");    
               }
            });   
}  
  }) 
}

//Character Limitations

/*Alphanumeric without space*/
var arr = ["Code","editCode"];
for (var i=0; i<arr.length; i++) {
    if ($('#'+arr[i]).length){
        document.getElementById(arr[i]).addEventListener("keydown",function(e) {   
            var keyCode = e.keyCode || e.which;
            if (e.ctrlKey || e.altKey) {
                e.preventDefault();
            } else {
                var notallowkeys = [48,49,50,51,52,53,54,55,56,57,188,190,191,59,220,221,222,219,173,61,192,111,106,109,107,46]
                var allowedkeys  = [96,97,98,99,100,101,102,103,104,105,9,8,16,46,35,36,37,38,39,40,65,66,67,68,69,70,71,72,73,74,75,76,77,78,79,80,81,82,83,84,85,86,87,88,89,90,48,49,50,51,52,53,54,55,56,57,33,34,35,36,37,38,39,40,45,12]
                if (e.shiftKey) {
                    if (notallowkeys.includes(keyCode)) {
                        e.preventDefault();
                    }
                } else {
                    if (!(allowedkeys.includes(keyCode))) {
                        e.preventDefault();
                    }
                }
            }
        });
        $('#'+arr[i]).on("cut copy paste",function(e){
            e.preventDefault();
        });  
    } 
}

/* Alphanumeric Space Dot only correct */ 
var arr = ["Classification","editClassification"];
for (var i=0; i<arr.length; i++) {
    if ($('#'+arr[i]).length){
        document.getElementById(arr[i]).addEventListener("keydown",function(e) {   
            var keyCode = e.keyCode || e.which;
            console.log(e.keyCode);
            if (e.ctrlKey || e.altKey) {
                e.preventDefault();
            } else {
               var notallowkeys = [48,49,50,51,52,53,54,55,56,57,188,191,59,220,221,222,219,173,61,192,111,106,109,107,46]
                var allowedkeys  = [190,32,96,97,98,99,100,101,102,103,104,105,9,8,16,46,35,36,37,38,39,40,65,66,67,68,69,70,71,72,73,74,75,76,77,78,79,80,81,82,83,84,85,86,87,88,89,90,48,49,50,51,52,53,54,55,56,57,33,34,35,36,37,38,39,40,45,12]
                if (e.shiftKey) {
                    if (notallowkeys.includes(keyCode)) {
                        e.preventDefault();
                    }
                } else {
                    if (!(allowedkeys.includes(keyCode))) {
                        e.preventDefault();
                    }
                }
            }
        });
        $('#'+arr[i]).on("cut copy paste",function(e){
            e.preventDefault();
        });  
    } 
}

/* Alphnumeric and special characters, not allow !\$"'~  */
var arr = ["Remarks","editRemarks"];
for (var i=0; i<arr.length; i++) {
    if ($('#'+arr[i]).length){
        document.getElementById(arr[i]).addEventListener("keydown",function(e) {   
            var keyCode = e.keyCode || e.which;
            if (e.ctrlKey || e.altKey) {
                e.preventDefault();
            } else {
               var notallowkeys = [220,222,49,52,192]
               var allowedkeys  = [9,8,46,32,35,36,37,38,39,40,65,66,67,68,69,70,71,72,73,74,75,76,77,78,79,80,81,82,83,84,85,86,87,88,89,90,103,104,105,100,101,102,97,98,99,96,48,49,50,51,52,53,54,55,56,57,173,61,110,190,191,221,219,111,106,109,107,59,188]
               if (e.shiftKey) {
                    if (notallowkeys.includes(keyCode)) {
                        e.preventDefault();
                    }
                } else {
                    if (!(allowedkeys.includes(keyCode))) {
                        e.preventDefault();
                    }
                }
            }
        });
        $('#'+arr[i]).on("cut copy paste",function(e){
            e.preventDefault();
        });  
    } 
}   
</script>
    