            <style>
.drop-zone {
 max-width: 591px;
  padding: 25px;
  display: flex;
  align-items: center;
  justify-content: center;
  text-align: center;
  font-family: "Quicksand", sans-serif;
  font-weight: 500;
  font-size: 20px;
  cursor: pointer;
  color: #ccc;
  border: 1px solid #ccc;
  border-radius: 10px;
  min-height: calc(1.5em + .5rem + calc(var(--bs-border-width) * 2));
  padding: .25rem .5rem;
  font-size: .875rem;
  border-radius: var(--bs-border-radius-sm);
  appearance: none;
  background-color: var(--bs-body-bg);
  background-clip: padding-box;
  border: var(--bs-border-width) solid var(--bs-border-color);
  border-radius: var(--bs-border-radius);
  transition: border-color .15s ease-in-out,box-shadow .15s ease-in-out;
  box-shadow: inset 0 0 10px #f2f1f1;
  font-family: 'Outfit';
  color: #666 !important;
  font-weight: normal;
  margin-bottom: 0px !important;
}

.drop-zone--over {
  border-style: solid;
}

.drop-zone__input {
  display: none;
}

.drop-zone__thumb {
  width: 100%;
  height: 100%;
  border-radius: 10px;
  overflow: hidden;
  background-color: #cccccc;
  background-size: cover;
  position: relative;
}

.drop-zone__thumb::after {
  content: attr(data-label);
  position: absolute;
  bottom: 0;
  left: 0;
  width: 100%;
  padding: 5px 0;
  color: #ffffff;
  background: rgba(0, 0, 0, 0.75);
  font-size: 1px;
  text-align: center;
}
.icon{
  font-size: 100px;
  color: #fff;
}

</style>
            <div class="user-dashboard">
                <div class="container">
                <div class="col-xl-12 col-lg-12">
                    <div class="row">
                        <div class="col-6"> 
                            <h3>Visitors List</h3>
                         </div>
                         <div class="col-6" style="text-align: right;"> 
                            <button class="btn-save" onclick="addform()">New</button>&nbsp;
                            <button class="btn-save" onclick="list()">Refresh</button>
                         </div>
                        </div>                                                 
                        </div>
                   <div class="row">
                <div class="col-xl-12 col-lg-12">
                    <div class="transactions-table table">
                        <div class="table">
                            <table id="listTable" class="table" style="width:100%">
                                <thead>
                                    <tr>
                                        <th>Purpose</th>
                                        <th>Meeting With</th>
                                        <th>Visitor Name</th>
                                        <th>Phone</th>
                                        <th>ID Card</th>
                                        <th>Numbr of Person</th>
                                        <th>Date</th>
                                        <th>In Time</th>
                                        <th>Out Time</th>
                                        <th style="width:50px">Status</th>
                                        <th style="width:50px"></th>
                                    </tr>
                                </thead>                                     
                                <tbody id="tbl_content">
                                    <tr>
                                        <td colspan='12'>
                                            <?php echo loadingText("Loading Admission Enquiries");?>
                                        </td>
                                    </tr>
                                </tbody>
                            </table>
                        </div>
                    </div>
                </div>
            </div>
            </div>
</div>

<div class="modal fade" id="confirmationtoadd" tabindex="-1" aria-labelledby="exampleModalLabel" aria-hidden="true" data-backdrop="static">
    <div class="modal-dialog modal-dialog-centered" style="max-width: 800px !important;">
        <div class="modal-content">
            <div class="modal-header">
                <h5 class="modal-title" id="exampleModalLabel">New Visitor</h5>
               <button type="button" class="btn-close" data-dismiss="modal"></button>
            </div>
            <div class="modal-body">
                 <form id="frm_create" name="frm_create" method="post" enctype="multipart/form-data" autocomplete="off">
                <div class="row">
                    <span id="ErrCommon"></span>
                    <div class="col-4">
                        <label class="form-label">Purpose</label><span style='color:red'>*</span>
                        <select class="form-select form-select-sm" name="Purpose" id="Purpose" onchange="clearInput('Purpose')">
                            <option value="0">Select Purpose</option>
                            <option value="1">Purpose</option>
                        </select> 
                        <span id="ErrPurpose" class="error_msg" style="color: red;"></span>
                    </div> 
                    <div class="col-4">
                        <label class="form-label">Meeting With</label><span style='color:red'>*</span>
                        <select class="form-select form-select-sm" name="MeetingWith" id="MeetingWith" onchange="clearInput('MeetingWith')">
                            <option value="0">Select Meeting With</option>
                            <option value="1">MeetingWith</option>
                        </select> 
                        <span id="ErrMeetingWith" class="error_msg" style="color: red;"></span>
                    </div>
                    <div class="col-4">
                        <label class="form-label">Mobile Number </label><span style='color:red'>*</span>
                         <input class="form-control form-control-sm" type="text" name="MobileNumber" id="MobileNumber" placeholder="Mobile Number" onkeypress="clearInput('MobileNumber')"></input>
                        <span id="ErrMobileNumber" class="error_msg" style="color: red;"></span>
                    </div>
                    <div class="col-12">
                        <label class="form-label">Visior's Name</label><span style='color:red'>*</span>
                         <input class="form-control form-control-sm" type="text" name="VisiorName" id="VisiorName" placeholder="Visior Name" onkeypress="clearInput('VisiorName')"></input>
                        <span id="ErrVisiorName" class="error_msg" style="color: red;"></span>
                    </div>
                    <div class="col-sm-8">
                        <label class="form-label">Relation Name</label><span style='color:red'>*</span>
                         <?php $RelationNames = getResponseData("macrl","l",""); ?>   
                          <select class="form-select form-select-sm" name="RelationName" id="RelationName" onchange="clearInput('RelationName')">
                            <option value="0">Select Relation Name</option>
                            <?php foreach($RelationNames as $RelationName) {?>   
                            <option value="<?php echo $RelationName['ID'];?>"><?php echo $RelationName['Relation'];?></option>
                            <?php } ?>                       
                        </select>  
                          <span id="ErrRelationName" style="color: red;" class="error_msg"></span>
                        </div>
                    <div class="col-4"></div>
                    <div class="col-4">
                        <label class="form-label">ID Card </label><span style='color:red'>*</span>
                         <input class="form-control form-control-sm" type="text" name="IDCard" id="IDCard" placeholder="ID Card" onkeypress="clearInput('IDCard')"></input>
                        <span id="ErrIDCard" class="error_msg" style="color: red;"></span>
                    </div>
                     <div class="col-sm-4">
                        <label class="form-label">Number Of Persons</label><span style='color:red'>*</span>
                         <input class="form-control form-control-sm" type="text" id="NumberOfPersons" name="NumberOfPersons" placeholder="Number Of Persons" value="" onkeypress="clearInput('NumberOfPersons')"></input> 
                          <span id="ErrNumberOfPersons" style="color: red;" class="error_msg"></span>
                    </div>
                    <div class="col-md-4">
                        <label class="form-label">Date<span style='color:red'>*</span></label>
                        <input class="form-control form-control-sm"  name="Date" id="Date" placeholder="Date" type="date" style="background:#fff" onchange="clearInput('Date')" autocomplete="off">
                        <div id="ErrDate" class="error_msg" style="color:red"></div>
                    </div> 
                    <div class="col-md-4">
                      <label class="form-label">In Time<span style='color:red'>*</span></label>
                    <select class="form-select form-select-sm" id="InTime" name="InTime" value="" onchange="clearInput('InTime')">
                      <option value="0">00:00</option>
                      <option value="1">12:00</option>
                    </select>
                     <div id="ErrInTime" class="error_msg" style="color:red"></div>
                    </div>
                    <script type="text/javascript">
                var input = $('.clockpicker-with-callbacks').clockpicker({
                    donetext: 'Done',
                        init: function() { 
                            console.log("colorpicker initiated");
                        },
                        beforeShow: function() {
                            console.log("before show");
                        },
                        afterShow: function() {
                            console.log("after show");
                        },
                        beforeHide: function() {
                            console.log("before hide");
                        },
                        afterHide: function() {
                            console.log("after hide");
                        },
                        beforeHourSelect: function() {
                            console.log("before hour selected");
                        },
                        afterHourSelect: function() {
                            console.log("after hour selected");
                        },
                        beforeDone: function() {
                            console.log("before done");
                        },
                        afterDone: function() {
                            console.log("after done");
                        }
                });

                // Manually toggle to the minutes view
                $('#check-minutes').click(function(e){
                    // Have to stop propagation here
                    e.stopPropagation();
                    input.clockpicker('show')
                            .clockpicker('toggleView', 'minutes');
                });
                </script>
                     <div class="col-md-4">
                      <label class="form-label">Out Time<span style='color:red'>*</span></label>
                      <select class="form-select form-select-sm" id="OutTime" name="OutTime" value="" onchange="clearInput('OutTime')">
                        <option value="0">00:00</option>
                        <option value="1">12:00</option>
                    </select>
                    <div id="ErrOutTime" class="error_msg" style="color:red"></div>
                </div>
                    <div class="col-md-4">
                        <label class="form-label">Attachment<span style='color:red'>*</span></label>
                        <div class="drop-zone">
                            <div class="icon"><i class="fas fa-cloud-upload-alt"></i></div>
                            <span class="drop-zone__prompt">Drop file here or click to upload</span>
                            <input type="file" name="myFile" class="drop-zone__input" name="Attachment" id="Attachment" onchange="clearInput('Attachment')" autocomplete="off">
                        </div>
                        <div id="ErrAttachment" class="error_msg" style="color:red"></div>
                    </div>
                    <div class="col-12">
                        <label class="form-label">Note</label><span style='color:red'>*</span>
                        <textarea class="form-control form-control-sm" type="text" id="Note" name="Note" placeholder="Note" value="" onkeypress="clearInput('Note')"></textarea>
                        <span id="ErrNote" class="error_msg" style="color: red;"></span>
                    </div>
                    <div class="col-12">
                        <label class="form-label">Remarks</label>
                        <input class="form-control form-control-sm" type="text" id="Remarks" name="Remarks" placeholder="Remarks" value="" onkeypress="clearInput('Remarks')"></input>
                        <span id="ErrRemarks" class="error_msg" style="color: red;"></span>
                    </div>
                    
                </div>
                </form>
            </div>
            <div class="modal-footer">
                 <button type="button" data-dismiss="modal" class="btn-cancel">Cancel</button>
                 <button type="button" href="javascript:void(0)" onclick="add()" class="btn-save">Save</button>
            </div>
        </div>                                                                                                                     
    </div>
</div>
<div class="modal fade" id="confirmationtoedit" tabindex="-1" aria-labelledby="exampleModalLabel" aria-hidden="true" data-backdrop="static">
    <div class="modal-dialog modal-dialog-centered" style="max-width: 800px !important;">
        <div class="modal-content">
            <div class="modal-header">
                <h5 class="modal-title" id="exampleModalLabel">Edit Admission Enquiry</h5>
                <button type="button" class="btn-close" data-dismiss="modal"></button>
            </div>
            <div class="modal-body">
                 <form id="frm_edit" name="frm_edit" method="post" enctype="multipart/form-data" autocomplete="off">
                <div class="row">
                    <span id="ErreditCommon"></span>
                    <div class="col-4">
                        <label class="form-label">Purpose</label><span style='color:red'>*</span>
                        <select class="form-select form-select-sm" name="Purpose" id="editPurpose" onchange="clearInput('editPurpose')">
                            <option value="0">Select Purpose</option>
                            <option value="1">Purpose</option>
                        </select> 
                        <span id="ErreditPurpose" class="error_msg" style="color: red;"></span>
                    </div> 
                    <div class="col-4">
                        <label class="form-label">Meeting With</label><span style='color:red'>*</span>
                        <select class="form-select form-select-sm" name="MeetingWith" id="MeetingWith" onchange="clearInput('editMeetingWith')">
                            <option value="0">Select Meeting With</option>
                            <option value="1">MeetingWith</option>
                        </select> 
                        <span id="ErreditMeetingWith" class="error_msg" style="color: red;"></span>
                    </div>
                    <div class="col-4">
                        <label class="form-label">Mobile Number </label><span style='color:red'>*</span>
                         <input class="form-control form-control-sm" type="text" name="MobileNumber" id="editMobileNumber" placeholder="Mobile Number" onkeypress="clearInput('MobileNumber')"></input>
                        <span id="ErreditMobileNumber" class="error_msg" style="color: red;"></span>
                    </div>
                    <div class="col-12">
                        <label class="form-label">Visior's Name</label><span style='color:red'>*</span>
                         <input class="form-control form-control-sm" type="text" name="VisiorName" id="editVisiorName" placeholder="Visior Name" onkeypress="clearInput('VisiorName')"></input>
                        <span id="ErreditVisiorName" class="error_msg" style="color: red;"></span>
                    </div>
                    <div class="col-sm-8">
                        <label class="form-label">Relation Name</label><span style='color:red'>*</span>
                         <?php $RelationNames = getResponseData("macrl","l",""); ?>   
                          <select class="form-select form-select-sm" name="RelationName" id="editRelationName" onchange="clearInput('editRelationName')">
                            <option value="0">Select Relation Name</option>
                            <?php foreach($RelationNames as $RelationName) {?>   
                            <option value="<?php echo $RelationName['ID'];?>"><?php echo $RelationName['RelationName'];?></option>
                            <?php } ?>
                        </select>  
                          <span id="ErreditRelationName" style="color: red;" class="error_msg"></span>
                        </div>
                    <div class="col-4">
                        <label class="form-label">ID Card </label><span style='color:red'>*</span>
                         <input class="form-control form-control-sm" type="text" name="IDCard" id="editIDCard" placeholder="ID Card" onkeypress="clearInput('editIDCard')"></input>
                        <span id="ErreditIDCard" class="error_msg" style="color: red;"></span>
                    </div>
                     <div class="col-sm-4">
                        <label class="form-label">Number Of Persons</label><span style='color:red'>*</span>
                         <input class="form-control form-control-sm" type="text" id="editNumberOfPersons" name="NumberOfPersons" placeholder="Number Of Persons" value="" onkeypress="clearInput('editNumberOfPersons')"></input> 
                          <span id="ErreditNumberOfPersons" style="color: red;" class="error_msg"></span>
                    </div>
                    <div class="col-md-4">
                        <label class="form-label">Date<span style='color:red'>*</span></label>
                        <input class="form-control form-control-sm"  name="Date" id="editDate" placeholder="Date" type="date" style="background:#fff" onchange="clearInput('editDate')" autocomplete="off">
                        <div id="ErreditDate" class="error_msg" style="color:red"></div>
                    </div> 
                    <div class="col-md-4">
                      <label class="form-label">In Time<span style='color:red'>*</span></label>
                    <select class="form-select form-select-sm" id="editInTime" name="InTime" value="" onchange="clearInput('editInTime')">
                      <option value="0">00:00</option>
                      <option value="1">12:00</option>
                    </select>
                     <div id="ErreditInTime" class="error_msg" style="color:red"></div>
                    </div>
                    <script type="text/javascript">
                var input = $('.clockpicker-with-callbacks').clockpicker({
                    donetext: 'Done',
                        init: function() { 
                            console.log("colorpicker initiated");
                        },
                        beforeShow: function() {
                            console.log("before show");
                        },
                        afterShow: function() {
                            console.log("after show");
                        },
                        beforeHide: function() {
                            console.log("before hide");
                        },
                        afterHide: function() {
                            console.log("after hide");
                        },
                        beforeHourSelect: function() {
                            console.log("before hour selected");
                        },
                        afterHourSelect: function() {
                            console.log("after hour selected");
                        },
                        beforeDone: function() {
                            console.log("before done");
                        },
                        afterDone: function() {
                            console.log("after done");
                        }
                });

                // Manually toggle to the minutes view
                $('#check-minutes').click(function(e){
                    // Have to stop propagation here
                    e.stopPropagation();
                    input.clockpicker('show')
                            .clockpicker('toggleView', 'minutes');
                });
                </script>
                     <div class="col-md-4">
                      <label class="form-label">Out Time<span style='color:red'>*</span></label>
                      <select class="form-select form-select-sm" id="editOutTime" name="OutTime" value="" onchange="clearInput('editOutTime')">
                        <option value="0">00:00</option>
                        <option value="1">12:00</option>
                    </select>
                    <div id="ErreditOutTime" class="error_msg" style="color:red"></div>
                </div>
                    <div class="col-md-4">
                        <label class="form-label">Attachment<span style='color:red'>*</span></label>
                        <input class="form-control form-control-sm" type="file"  name="Attachment" id="editAttachment" placeholder="Attachment" type="Attachment" onchange="clearInput('editAttachment')" autocomplete="off">
                        <div id="ErreditAttachment" class="error_msg" style="color:red"></div>
                    </div>
                    <div class="col-sm-12">
                        <div class="drop-zone">
                            <div class="icon"><i class="fas fa-cloud-upload-alt"></i></div>
                            <span class="drop-zone__prompt">Drop file here or click to upload</span>
                            <input type="file" name="myFile" class="drop-zone__input" name="Attachment" id="editAttachment" onchange="clearInput('editAttachment')" autocomplete="off">
                        </div>
                    </div>
                    <div class="col-12">
                        <label class="form-label">Note</label><span style='color:red'>*</span>
                        <textarea class="form-control form-control-sm" type="text" id="editNote" name="Note" placeholder="Note" value="" onkeypress="clearInput('editNote')"></textarea>
                        <span id="ErreditNote" class="error_msg" style="color: red;"></span>
                    </div>
                    <div class="col-12">
                        <label class="form-label">Remarks</label>
                        <input class="form-control form-control-sm" type="text" id="editRemarks" name="Remarks" placeholder="Remarks" value="" onkeypress="clearInput('editRemarks')"></input>
                        <span id="ErreditRemarks" class="error_msg" style="color: red;"></span>
                    </div>
                </div>
                </form>
            </div>
            <div class="modal-footer">
                <button type="button" data-dismiss="modal" class="btn-cancel">Cancel</button>
                 <button type="button" href="javascript:void(0)" onclick="edit()" class="btn-save">Update</button>
            </div>
        </div>                                                                                                                     
    </div>
</div>

<div class="modal fade" id="confirmationtoview" tabindex="-1" aria-labelledby="exampleModalLabel" aria-hidden="true" data-backdrop="static">
    <div class="modal-dialog modal-dialog-centered" style="max-width: 800px !important;">
        <div class="modal-content">
            <div class="modal-header">
                <h5 class="modal-title" id="exampleModalLabel">View Batch</h5>
                 <button type="button" class="btn-close" data-dismiss="modal"></button>
            </div>
            <div class="modal-body">
                <div class="row">
                    <div class="col-sm-4">
                        <div style="font-weight: bold;">Purpose</div>
                        <div id="viewPurpose"></div>
                    </div>
                    <div class="col-sm-4">
                        <div style="font-weight: bold;">Meeting With</div>
                        <div id="viewMeetingWith"></div>
                    </div>
                    <div class="col-sm-4">
                        <div style="font-weight: bold;">Mobile Number</div>
                        <div id="viewMobileNumber"></div>
                    </div>
                    <div class="col-sm-12">
                        <div style="font-weight: bold;">Visitor's Name</div>
                        <div id="viewVisitorName"></div>
                    </div>
                    <div class="col-sm-8">
                        <div style="font-weight: bold;">Relation Name</div>
                        <span id="viewRelationName"></span>
                    </div>
                    <div class="col-sm-4">
                        <div style="font-weight: bold;">ID Card</div>
                      <span id="viewIDCard"></span>
                    </div>
                    <div class="col-sm-4">
                        <div style="font-weight: bold;">Number Of Persons</div>
                      <span id="viewNumberOfPersons"></span>
                    </div>
                    <div class="col-sm-4">
                        <div style="font-weight: bold;">Date</div>
                      <span id="viewDate"></span>
                    </div>
                    <div class="col-sm-4">
                        <div style="font-weight: bold;">In Time</div>
                      <span id="viewInTime"></span>
                    </div>
                    <div class="col-sm-4">
                        <div style="font-weight: bold;">Out Time</div>
                      <span id="viewOutTime"></span>
                    </div>
                    <div class="col-sm-12">
                        <div style="font-weight: bold;">Note</div>
                      <span id="viewNote"></span>
                    </div>
                    <div class="col-sm-12">
                        <div style="font-weight: bold;">Remarks</div>
                        <div id="viewRemarks"></div>
                    </div>
                    <div class="col-sm-6">
                        <div style="font-weight: bold;">Status</div>
                        <div id="viewStatus"></div>
                    </div>
                    <div class="col-sm-6">
                        <div style="font-weight: bold;">Created On</div>
                        <div id="viewCreatedOn"></div>
                    </div>
                </div>
            </div>
            <div class="modal-footer"> 
                 <button type="button" data-dismiss="modal" class="btn-cancel">Close</button>
            </div>
        </div>                                                                                                                     
    </div>
</div>
<div class="modal fade" id="Success" tabindex="-1" aria-labelledby="exampleModalLabel" aria-hidden="true" data-bs-backdrop="static">
    <div class="modal-dialog modal-dialog-centered">
        <div class="modal-content">
            <div class="modal-body" style="text-align: center;">
                <div id="sucess">
                    <img id="Sucess" style="width: 150px;" src="assets/sucess.gif" alt=""/>
                </div>
                <h3 class="title">Success.</h3>  
                 <button type="button" onclick="list()" class="btn-save">Continue</button>         
            </div>
        </div>
    </div>
</div>
     
<script>
function list() {
      $('#Success').modal("hide");
        var html = '<tr>'
                + '<td colspan="6" style="text-align: center;background:#fff !important">Loading Admission Enquiries</td>'
                + '</tr>'
      $('#tbl_content').html(html);
    $.post(URL+ "webservice.php?action=l&method=mabl","",function(data){
      var obj = JSON.parse(data);
        if (obj.status=="success") {
            var html = "";
            i=0;
            $.each(obj.data, function (index, data) {
                 html += '<tr class="'+((i%2!=0) ? 'rEven' : 'rOdd')+'">'
                            + '<td>' + data.Purpose + '</td>'
                            + '<td>' + data.MeetingWith + '</td>' 
                            + '<td>' + data.VisitorName + '</td>' 
                            + '<td>' + data.Phone + '</td>' 
                            + '<td>' + data.IDCard + '</td>' 
                            + '<td>' + data.NumbrOfPerson + '</td>' 
                            + '<td>' + data.Date + '</td>' 
                            + '<td>' + data.InTime + '</td>' 
                            + '<td>' + data.OutTime + '</td>' 
                            + '<td>' + ( (data.Status=="1") ? "<span class='badge bg-success'>Active</span>" : "<span class='badge bg-secondary'>Deactive</span>" ) + '</td>'
                             + '<td style="text-align:right">' 
                                + '<span onclick="editform(\''+data.ID+'\')" class="editLink"  title="Edit Record"><i class="fi fi-rs-pencil"></i></span>&nbsp;&nbsp;'
                               + '<span onclick="viewform(\''+data.ID+'\')" class="viewLink"  title="View Record"><i class="fi fi-rs-web-test"></i></span>&nbsp;&nbsp;'
                               + '<span onclick="openDeleteConfirmation(\''+data.ID+'\',\'r\',\'mabl\',\''+data.Phone+'\',\'l\')" class="deleteLink" title="Delete Record"><i class="fi fi-rs-trash"></i></span>'
                               + '</td>'
                             + '</tr>' 
                      + '</tr>';
                      i++;
            });
            if(obj.data.length==0){
            html += '<tr>'
                + '<td colspan="12" style="text-align: center;background:#fff !important">No data found</td>'
                + '</tr>'
            }   
            $('#tbl_content').html(html);
        } else {
             $('#popupcontent').html( error(obj.message));
        }  
    });
}

setTimeout("list()",2000);

function addform(){
        $('#confirmationtoadd').modal("show"); 
        $('#Purpose').val("0"); 
        $('#RelationName').val("0"); 
        $('#MeetingWith').val("0"); 
        $('#MobileNumber').val(""); 
        $('#VisiorName').val(""); 
        $('#IDCard').val(""); 
        $('#NumberOfPersons').val(""); 
        $('#Note').val(""); 
        $('#Date').val(""); 
        $('#InTime').val("0"); 
        $('#OutTime').val("0"); 
        $('#Attachment').val(""); 
        $('#Remarks').val("");
        
        $('#ErrPurpose').html("");
        $('#ErrRelationName').html("");
        $('#ErrMeetingWith').html("");
        $('#ErrMobileNumber').html(""); 
        $('#ErrVisiorName').html(""); 
        $('#ErrIDCard').html(""); 
        $('#ErrNumberOfPersons').html(""); 
        $('#ErrNote').html(""); 
        $('#ErrDate').html(""); 
        $('#ErrInTime').html(""); 
        $('#ErrOutTime').html(""); 
        $('#ErrAttachment').html(""); 
        $('#ErrRemarks').html(""); 
        $('#ErrCommon').html(""); 
         
        $("#Purpose").removeClass("highlight_error");
        $("#RelationName").removeClass("highlight_error");
        $("#MeetingWith").removeClass("highlight_error");
        $("#MobileNumber").removeClass("highlight_error");
        $("#VisiorName").removeClass("highlight_error");
        $("#IDCard").removeClass("highlight_error");
        $("#NumberOfPersons").removeClass("highlight_error");
        $("#Note").removeClass("highlight_error");
        $("#Date").removeClass("highlight_error");
        $("#InTime").removeClass("highlight_error");
        $("#OutTime").removeClass("highlight_error");
        $("#Attachment").removeClass("highlight_error");
        $("#Remarks").removeClass("highlight_error");
        
        window.addEventListener("load", function() {
  const name = 'RelationName';
  const value = 0;
  const sel = document.querySelector("[RelationName]"); // or give it an ID and use document.getElementById("req_one")
  if (sel) {
    sel.options[sel.options.length] = new Option(name, value);
  } else {
    alert("Where did the sel go?");
  }
})


}

function add(){
   var error = 0;
       if ($('#Purpose').val()=="0"){
            $('#ErrPurpose').html("Please select Purpose");
         $("#Purpose").addClass("highlight_error");
          error++;
    }  else {
        $("#Purpose").removeClass("highlight_error");
            $('#ErrPurpose').html(""); 
    }
    if ($('#MeetingWith').val()=="0"){
            $('#ErrMeetingWith').html("Please select Meeting With");
         $("#MeetingWith").addClass("highlight_error");
          error++;
    }  else {
        $("#MeetingWith").removeClass("highlight_error");
            $('#ErrMeetingWith').html(""); 
    }
    if ($('#MobileNumber').val()==""){
            $('#ErrMobileNumber').html("Please enter Mobile Number");
            $("#MobileNumber").addClass("highlight_error");
          error++;
    }  else {
        $("#MobileNumber").removeClass("highlight_error");
            $('#ErrMobileNumber').html(""); 
    } 
    if ($('#VisiorName').val()==""){
            $('#ErrVisiorName').html("Please enter Visior Name");
            $("#VisiorName").addClass("highlight_error");
          error++;
    }  else {
        $("#VisiorName").removeClass("highlight_error");
            $('#ErrVisiorName').html(""); 
    }
    if ($('#RelationName').val()=="0"){
            $('#ErrRelationName').html("Please select Relation Name");
            $("#RelationName").addClass("highlight_error");
          error++;
    }  else {
        $("#RelationName").removeClass("highlight_error");
            $('#ErrRelationName').html(""); 
    } 
    if ($('#IDCard').val()==""){
            $('#ErrIDCard').html("Please enter ID Card");
            $("#IDCard").addClass("highlight_error");
          error++;
    }  else {
        $("#IDCard").removeClass("highlight_error");
            $('#ErrIDCard').html(""); 
    }
    if ($('#NumberOfPersons').val()==""){
            $('#ErrNumberOfPersons').html("Please enter Number Of Person");
            $("#NumberOfPersons").addClass("highlight_error");
          error++;
    }  else {
        $("#NumberOfPersons").removeClass("highlight_error");
            $('#ErrNumberOfPersons').html(""); 
    } 
     if ($('#Date').val()==""){
            $('#ErrDate').html("Please select Date");
            $("#Date").addClass("highlight_error");
          error++;
    }  else {
        $("#Date").removeClass("highlight_error");
            $('#ErrDate').html(""); 
    }
    if ($('#Note').val()==""){
            $('#ErrNote').html("Please enter Note");
            $("#Note").addClass("highlight_error");
          error++;
    }  else {
        $("#Note").removeClass("highlight_error");
            $('#ErrNote').html(""); 
    }
   
    if ($('#InTime').val()=="0"){
            $('#ErrInTime').html("Please select In Time");
            $("#InTime").addClass("highlight_error");
          error++;
    }  else {
        $("#InTime").removeClass("highlight_error");
            $('#ErrInTime').html(""); 
    }
    if ($('#OutTime').val()=="0"){
            $('#ErrOutTime').html("Please select Out Time");
            $("#OutTime").addClass("highlight_error");
          error++;
    }  else {
        $("#OutTime").removeClass("highlight_error");
            $('#ErrOutTime').html(""); 
    }
    if ($('#Attachment').val()==""){
            $('#ErrAttachment').html("Please select Attachment");
            $("#Attachment").addClass("highlight_error");
          error++;
    }  else {
        $("#Attachment").removeClass("highlight_error");
            $('#ErrAttachment').html(""); 
    }
   
     if(error==0){
        var param = $('#frm_create').serialize();
        $.post(URL+"webservice.php?action=a&method=mabl",param,function(data){
        var obj = JSON.parse(data); 
        if (obj.status=="success") {
             $('#confirmationtoadd').modal("hide"); 
             $('#Success').modal("show");    
        }   else {
            $('#ErrCommon').html(print_inlineError(obj.message));
        }
    });
   } 
}

function editform(ID){
     $('#confirmationtoedit').modal("show");
     $("#editPurpose").removeClass("highlight_error");
     $("#editRelationName").removeClass("highlight_error");
     $("#editMeetingWith").removeClass("highlight_error");
     $("#editMobileNumber").removeClass("highlight_error");
     $("#editVisiorName").removeClass("highlight_error");
     $("#editIDCard").removeClass("highlight_error");
     $("#editNumberOfPersons").removeClass("highlight_error");
     $("#editNote").removeClass("highlight_error");
     $("#editDate").removeClass("highlight_error");
     $("#editOutTime").removeClass("highlight_error");
     $("#editInTime").removeClass("highlight_error");
     $("#editAttachment").removeClass("highlight_error");
     $("#editRemarks").removeClass("highlight_error");
     $('#ErreditCommon').html(""); 
     $('#ErreditPurpose').html(""); 
     $('#ErreditRelationName').html(""); 
     $('#ErreditMeetingWith').html(""); 
     $('#ErreditMobileNumber').html(""); 
     $('#ErreditVisiorName').html(""); 
     $('#ErreditIDCard').html(""); 
     $('#ErreditNumberOfPerson').html(""); 
     $('#ErreditNote').html(""); 
     $('#ErreditDate').html(""); 
     $('#ErreditInTime').html(""); 
     $('#ErreditOutTime').html(""); 
     $('#ErreditAttachment').html(""); 
     $('#ErreditRemarks').html(""); 
     $('#ErreditCommon').html(""); 
      $.post(URL+ "webservice.php?action=g&method=mabl&ID="+ID,"",function(data){
      
        var obj = JSON.parse(data);
        if (obj.status=="success") {
            var html = "";
            $.each(obj.data, function (index, data) {
                $('#editPurpose').val(data.Purpose);
                $('#editID').val(data.ID);
                $('#editPurpose').val(data.Purpose);
                $('#editRelationName').val(data.RelationName);
                $('#editMeetingWith').val(data.MeetingWith);
                $('#editMobileNumber').val(data.MobileNumber);
                $('#editVisiorName').val(data.VisiorName);
                $('#editIDCard').val(data.IDCard);
                $('#editNumberOfPersons').val(data.NumberOfPersons);
                $('#editNote').val(data.Note);
                $('#editDate').val(data.Date);
                $('#editInTime').val(data.InTime);
                $('#editOutTime').val(data.OutTime);
                $('#editStatus').val(data.Status);
                $('#editAttachment').val(data.Attachment);
                $('#editRemarks').val(data.Remarks);
            });   
}  
        else {
            $('#ErreditCommon').html(print_inlineError(obj.message));
        }
  });
}

function edit(ID){
     var error = 0;
    if ($('#editPurpose').val()=="0"){
            $('#ErreditPurpose').html("Please select Purpose");
            $("#editPurpose").addClass("highlight_error");
           error++;
    }  else {
           $("#editPurpose").removeClass("highlight_error");
           $('#ErreditPurpose').html(""); 
    }
     if ($('#editMobileNumber').val()==""){
            $('#ErreditMobileNumber').html("Please enter Mobile Number");
            $("#editMobileNumber").addClass("highlight_error");
            error++;
    }  else {
            $("#editMobileNumber").removeClass("highlight_error");
            $('#ErreditMobileNumber').html(""); 
    } 
    if ($('#editVisiorName').val()==""){
            $('#ErrVisiorName').html("Please enter Visior Name");
            $("#editVisiorName").addClass("highlight_error");
            error++;
    }  else {
            $("#editVisiorName").removeClass("highlight_error");
            $('#ErreditVisiorName').html(""); 
    }  
    if ($('#editRelationName').val()=="0"){
            $('#ErreditRelationName').html("Please select Relation Name");
            $("#editRelationName").addClass("highlight_error");
          error++;
    }  else {
        $("#editRelationName").removeClass("highlight_error");
            $('#ErreditRelationName').html(""); 
    }
    if ($('#editIDCard').val()==""){
            $('#ErrIDCard').html("Please enter ID Card");
            $("#editIDCard").addClass("highlight_error");
            error++;
    }  else {
            $("#editIDCard").removeClass("highlight_error");
            $('#ErreditIDCard').html(""); 
    }
    if ($('#editNumberOfPersons').val()==""){
            $('#ErrNumberOfPersons').html("Please enter Number Of Person");
            $("#editNumberOfPersons").addClass("highlight_error");
            error++;
    }  else {
            $("#editNumberOfPersons").removeClass("highlight_error");
            $('#ErreditNumberOfPersons').html(""); 
    }
    if ($('#editDate').val()==""){
            $('#ErrDate').html("Please select Date");
            $("#editDate").addClass("highlight_error");
            error++;
    }  else {
            $("#editDate").removeClass("highlight_error");
            $('#ErreditDate').html(""); 
    }
    if ($('#editNote').val()==""){
            $('#ErrNote').html("Please enter Note");
            $("#editNote").addClass("highlight_error");
            error++;
    }  else {
            $("#editNote").removeClass("highlight_error");
            $('#ErreditNote').html(""); 
    } 
    
    if ($('#editOutTime').val()=="0"){
            $('#ErrOutTime').html("Please select Out Time");
            $("#editOutTime").addClass("highlight_error");
            error++;
    }  else {
            $("#editOutTime").removeClass("highlight_error");
            $('#ErreditOutTime').html(""); 
    }
    if ($('#editInTime').val()=="0"){
            $('#ErrInTime').html("Please select In Time");
            $("#editInTime").addClass("highlight_error");
            error++;
    }  else {
            $("#editInTime").removeClass("highlight_error");
            $('#ErreditInTime').html(""); 
    }
    if ($('#editAttachment').val()==""){
            $('#ErrAttachment').html("Please select Attachment");
            $("#editAttachment").addClass("highlight_error");
            error++;
    }  else {
            $("#editAttachment").removeClass("highlight_error");
            $('#ErreditAttachment').html(""); 
    }
   
  if(error==0){
    var param = $('#frm_edit').serialize();
    $.post(URL+"webservice.php?action=u&method=mabl",param,function(data){
    var obj = JSON.parse(data); 
    if (obj.status=="success") {
        $('#confirmationtoedit').modal("hide");
        $('#Success').modal("show");  
    } else {
        $('#ErreditCommon').html(print_inlineError(obj.message));
    }
  });
}
}

function viewform(ID){
     $('#confirmationtoview').modal("show"); 
     $.post(URL+ "webservice.php?action=g&method=mabl&ID="+ID,"",function(data){
          
        var obj = JSON.parse(data);
        if (obj.status=="success") {
            $.each(obj.data, function (index, data) {
                $('#viewPurpose').html(data.Purpose=="" ? "&nbsp;" : data.Purpose);
                $('#viewRelationName').html(data.RelationName=="" ? "&nbsp;" : data.RelationName);
                $('#viewMobileNumber').html(data.MobileNumber=="" ? "&nbsp;" : data.MobileNumber);
                $('#viewVisiorName').html(data.VisiorName=="" ? "&nbsp;" : data.VisiorName);
                $('#viewIDCard').html(data.IDCard=="" ? "&nbsp;" : data.IDCard);
                $('#viewNumberOfPersons').html(data.NumberOfPersons=="" ? "&nbsp;" : data.NumberOfPersons);
                $('#viewNote').html(data.Note=="" ? "&nbsp;" : data.Note);
                $('#viewDate').html(data.Date=="" ? "&nbsp;" : data.Date);
                $('#viewInTime').html(data.InTime=="" ? "&nbsp;" : data.InTime);
                $('#viewOutTime').html(data.OutTime=="" ? "&nbsp;" : data.OutTime);
                $('#viewAttachment').html(data.Attachment=="" ? "&nbsp;" : data.Attachment);
                $('#viewRemarks').html(data.Remarks=="" ? "&nbsp;" : data.Remarks);
                $('#viewCreatedOn').html(data.CreatedOn=="" ? "&nbsp;" : data.CreatedOn);
               if(data.Status=="1"){
                $('#viewStatus').html("Active");    
               }
               if(data.Status=="0"){
                $('#viewStatus').html("Deactive");    
               }
            });   
}  
  }) 
}


//Character Limitations

/*Alphanumeric without space*/
var arr = ["Purpose","editName"];
for (var i=0; i<arr.length; i++) {
    if ($('#'+arr[i]).length){
        document.getElementById(arr[i]).addEventListener("keydown",function(e) {   
            var keyCode = e.keyCode || e.which;
            if (e.ctrlKey || e.altKey) {
                e.preventDefault();
            } else {
                var notallowkeys = [48,49,50,51,52,53,54,55,56,57,188,190,191,59,220,221,222,219,173,61,192,111,106,109,107,46]
                var allowedkeys  = [96,97,98,99,100,101,102,103,104,105,9,8,16,46,35,36,37,38,39,40,65,66,67,68,69,70,71,72,73,74,75,76,77,78,79,80,81,82,83,84,85,86,87,88,89,90,48,49,50,51,52,53,54,55,56,57,33,34,35,36,37,38,39,40,45,12]
                if (e.shiftKey) {
                    if (notallowkeys.includes(keyCode)) {
                        e.preventDefault();
                    }
                } else {
                    if (!(allowedkeys.includes(keyCode))) {
                        e.preventDefault();
                    }
                }
            }
        });
        $('#'+arr[i]).on("cut copy paste",function(e){
            e.preventDefault();
        });  
    } 
}


/* Numbers only*/ 
var arr = ["PhoneNumber"];
for (var i=0; i<arr.length; i++) {
    if ($('#'+arr[i]).length){
        document.getElementById(arr[i]).addEventListener("keydown",function(e) {   
            var keyCode = e.keyCode || e.which;
            if (e.ctrlKey || e.altKey) {
                e.preventDefault();
            } else {
                var notallowkeys = [32,173,16,48,49,50,51,52,53,54,55,56,57,16,188,190,191,59,222,220,219,221,61,192,111,106,109,107,46,110,190,65,66,67,68,69,70,71,72,73,74,75,76,77,78,79,80,81,82,83,84,85,86,87,88,89,90]
                var allowedkeys  = [9,8,46,35,36,37,38,39,40,48,49,50,51,52,53,54,55,56,57,103,104,105,100,101,102,97,98,99,96]
                if (e.shiftKey) {
                    if (notallowkeys.includes(keyCode)) {
                        e.preventDefault();
                    }
                } else {
                    if (!(allowedkeys.includes(keyCode))) {
                        e.preventDefault();
                    }
                }
            }
        });
        $('#'+arr[i]).on("cut copy paste",function(e){
            e.preventDefault();
        });  
    } 
}

/*Alphanumeric without space and allow .@_*/ 
if ($('#EmailID').length){
    $('#EmailID').keydown(function (e) {
        var keyCode = e.keyCode || e.which;
        if (e.ctrlKey || e.altKey) {
            e.preventDefault();
        } else {
            console.log(keyCode);
            var notallowkeys = [32,48,49,52,53,54,55,56,57,188,191,59,220,221,222,219,61,192,106,107,46,51,191,190,188,173]
            var allowedkeys  = [190,50,51,111,109,110,96,97,98,99,100,101,102,103,104,105,9,8,16,46,35,36,37,38,39,40,65,66,67,68,69,70,71,72,73,74,75,76,77,78,79,80,81,82,83,84,85,86,87,88,89,90,48,49,50,52,53,54,55,56,57,33,34,35,36,37,38,39,40,45,12]
            if (e.shiftKey) {
                if (notallowkeys.includes(keyCode)) {
                    e.preventDefault();
                }
            } else {
                if (!(allowedkeys.includes(keyCode))) {
                    e.preventDefault();
                }
            }
        }
    });
     $('#EmailID').on("cut copy paste",function(e){
        e.preventDefault();
    });
}



/* Alphnumeric and special characters, not allow !\$"'~  */
var arr = ["Remarks","editRemarks"];
for (var i=0; i<arr.length; i++) {
    if ($('#'+arr[i]).length){
        document.getElementById(arr[i]).addEventListener("keydown",function(e) {   
            var keyCode = e.keyCode || e.which;
            if (e.ctrlKey || e.altKey) {
                e.preventDefault();
            } else {
               var notallowkeys = [220,222,49,52,192]
               var allowedkeys  = [9,8,46,32,35,36,37,38,39,40,65,66,67,68,69,70,71,72,73,74,75,76,77,78,79,80,81,82,83,84,85,86,87,88,89,90,103,104,105,100,101,102,97,98,99,96,48,49,50,51,52,53,54,55,56,57,173,61,110,190,191,221,219,111,106,109,107,59,188]
               if (e.shiftKey) {
                    if (notallowkeys.includes(keyCode)) {
                        e.preventDefault();
                    }
                } else {
                    if (!(allowedkeys.includes(keyCode))) {
                        e.preventDefault();
                    }
                }
            }
        });
        $('#'+arr[i]).on("cut copy paste",function(e){
            e.preventDefault();
        });  
    } 
}

document.querySelectorAll(".drop-zone__input").forEach((inputElement) => {
  const dropZoneElement = inputElement.closest(".drop-zone");

  dropZoneElement.addEventListener("click", (e) => {
    inputElement.click();
  });

  inputElement.addEventListener("change", (e) => {
    if (inputElement.files.length) {
      updateThumbnail(dropZoneElement, inputElement.files[0]);
    }
  });

  dropZoneElement.addEventListener("dragover", (e) => {
    e.preventDefault();
    dropZoneElement.classList.add("drop-zone--over");
  });

  ["dragleave", "dragend"].forEach((type) => {
    dropZoneElement.addEventListener(type, (e) => {
      dropZoneElement.classList.remove("drop-zone--over");
    });
  });

  dropZoneElement.addEventListener("drop", (e) => {
    e.preventDefault();

    if (e.dataTransfer.files.length) {
      inputElement.files = e.dataTransfer.files;
      updateThumbnail(dropZoneElement, e.dataTransfer.files[0]);
    }

    dropZoneElement.classList.remove("drop-zone--over");
  });
});

/**
 * Updates the thumbnail on a drop zone element.
 *
 * @param {HTMLElement} dropZoneElement
 * @param {File} file
 */
function updateThumbnail(dropZoneElement, file) {
  let thumbnailElement = dropZoneElement.querySelector(".drop-zone__thumb");

  // First time - remove the prompt
  if (dropZoneElement.querySelector(".drop-zone__prompt")) {
    dropZoneElement.querySelector(".drop-zone__prompt").remove();
  }

  // First time - there is no thumbnail element, so lets create it
  if (!thumbnailElement) {
    thumbnailElement = document.createElement("div");
    thumbnailElement.classList.add("drop-zone__thumb");
    dropZoneElement.appendChild(thumbnailElement);
  }

  thumbnailElement.dataset.label = file.name;

  // Show thumbnail for image files
  if (file.type.startsWith("image/")) {
    const reader = new FileReader();

    reader.readAsDataURL(file);
    reader.onload = () => {
      thumbnailElement.style.backgroundImage = `url('${reader.result}')`;
    };
  } else {
    thumbnailElement.style.backgroundImage = null;
  }
}


  
</script>
    