<?php include_once("sidemenu.php");?>
<style>
.drop-zone {
  height: 200px;
  padding: 25px;
  display: flex;
  align-items: center;
  justify-content: center;
  text-align: center;
  font-family: "Quicksand", sans-serif;
  font-weight: 500;
  font-size: 20px;
  cursor: pointer;
  color: #cccccc;
  border: 2px dashed #009578;
  border-radius: 10px;
}

.drop-zone--over {
  border-style: solid;
}

.drop-zone__input {
  display: none;
}

.drop-zone__thumb {
  width: 100%;
  height: 100%;
  border-radius: 10px;
  overflow: hidden;
  background-color: #cccccc;
  background-size: cover;
  position: relative;
}

.drop-zone__thumb::after {
  content: attr(data-label);
  position: absolute;
  bottom: 0;
  left: 0;
  width: 100%;
  padding: 5px 0;
  color: #ffffff;
  background: rgba(0, 0, 0, 0.75);
  font-size: 14px;
  text-align: center;
}
.icon{
  font-size: 100px;
  color: #fff;
}

</style> 
<div class="user-dashboard">
    <div class="container">
      <h3 class="title">Documents</h3>
       <div class="row">
            <div class="col-12" style="text-align: right;"> 
                <button class="btn-save" onclick="addform()">New</button>
            </div>
            <div class="col-xl-12 col-lg-12">
                <table id="listTable" class="table" style="width:100%">
                    <thead>
                        <tr>
                            <th>Document Type</th>
                            <th>Document Title</th>
                            <th style="width:50px">Status</th>
                            <th style="width:100px"></th>
                        </tr>
                    </thead>
                    <tbody id="tbl_content">
                        <tr>
                            <td colspan='5'>
                                <?php echo loadingText("Loading Documents");?>
                            </td>
                        </tr>
                    </tbody>
                </table>
            </div>
        </div>
</div>
</div> 
<div class="modal fade" id="confirmationtoadd" tabindex="-1" aria-labelledby="exampleModalLabel" aria-hidden="true" data-backdrop="static">
    <div class="modal-dialog modal-dialog-centered"  style="max-width: 800px !important;">
        <div class="modal-content">
            <div class="modal-header">
                <h5 class="modal-title" id="exampleModalLabel">New Document</h5>
                <button type="button" class="btn-close" data-dismiss="modal"></button>
            </div>
            <div class="modal-body">
                 <form id="frm_create" name="frm_create" method="post" enctype="multipart/form-data" autocomplete="off">
                <div class="row">
                 <span id="ErrCommon"></span>
                 <div class="col-sm-6">
                        <label class="form-label">Document Type</label><span style='color:red'>*</span>
                        <?php $DocumentTypes = getResponseData("mcdtl","l",""); ?>   
                          <select class="form-select form-select-sm" name="DocumentType" id="DocumentType" onchange="clearInput('DocumentType')">
                            <option value="0">Select Document Type</option>
                            <?php foreach($DocumentTypes as $DocumentType) {?>   
                            <option value="<?php echo $DocumentType['ID'];?>"><?php echo $DocumentType['DocumentType'];?></option>
                            <?php } ?>
                        </select>
                          <span id="ErrDocumentType" style="color: red;" class="error_msg"></span>
                    </div>
                    <div class="col-sm-12 mb-3">
                        <label class="form-label">Document Title</label><span style='color:red'>*</span>
                         <input class="form-control form-control-sm" type="text" id="DocumentTitle" name="DocumentTitle" placeholder="Document Title" value="" onkeypress="clearInput('DocumentTitle')"></input> 
                          <span id="ErrDocumentTitle" style="color: red;" class="error_msg"></span>
                    </div> 
                     <div class="col-sm-12">
                        <div class="drop-zone">
                            <div class="icon"><i class="fas fa-cloud-upload-alt"></i></div>
                            <span class="drop-zone__prompt">Drop file here or click to upload</span>
                            <input type="file" name="myFile" class="drop-zone__input">
                        </div>
                    </div>
                     <div class="col-12">
                        <label class="form-label">Remarks</label>
                        <input class="form-control form-control-sm" type="text" id="Remarks" name="Remarks" placeholder="Remarks" value="" onkeypress="clearInput('Remarks')"></input>
                        <span id="ErrRemarks" class="error_msg" style="color: red;"></span>
                    </div>
                </form>
                <div class="modal-footer mb-3">
                 <button type="button" data-dismiss="modal" class="btn-cancel">Cancel</button>
                 <button type="button" href="javascript:void(0)" onclick="confirmationtoSubmit()" class="btn-save">Save</button>
            </div>
            </div>
            
        </div>                                                                                                                     
    </div>
</div>


<div class="modal fade" id="confirmation" tabindex="-1" aria-labelledby="exampleModalLabel" aria-hidden="true" data-backdrop="static" onclick="event.stopPropagation()">
    <div class="modal-dialog modal-dialog-centered">
        <div class="modal-content">
            <div class="modal-header">
                <h5 class="modal-title" id="exampleModalLabel">Confirmation</h5>
                 <button type="button" class="btn-close" data-dismiss="modal"></button>
            </div>
            <div class="modal-body">
                 Do you want Add Student? 
            </div>
            <div class="modal-footer">
                <button type="button" class="btn-cancel" data-dismiss="modal">Cancel</button>
                <button type="button" onclick="Submit()" class="btn-save">Yes, Continue</button>
            </div>
        </div>
    </div>
</div>

<div class="modal fade" id="Success" tabindex="-1" aria-labelledby="exampleModalLabel" aria-hidden="true" data-backdrop="static">
    <div class="modal-dialog modal-dialog-centered">
        <div class="modal-content">
            <div class="modal-body" style="text-align: center;">
                <div id="sucess">
                    <img id="Sucess" style="width: 150px;" src="assets/sucess.gif" alt=""/>
                </div>
                <h3 class="title">Successfully Added.</h3>  
                 <button type="button" href="javascript:void(0)" onclick="dashboard()" class="btn-save">Continue</button>         
            </div>
        </div>
    </div>
</div>

<script>

function list() {
      $('#Success').modal("hide");
    $.post(URL+ "webservice.php?action=l&method=ms","",function(data){
      var obj = JSON.parse(data);
        if (obj.status=="success") {
            var html = "";
            i=0;
            $.each(obj.data, function (index, data) {
                html += '<tr class="'+((i%2!=0) ? 'rEven' : 'rOdd')+'">'
                            + '<td>' + data.Code + '</td>'
                            + '<td>' + data.BoardOfEducation + '</td>' 
                            + '<td>' + data.Category + '</td>' 
                            + '<td>' + ( (data.Status=="1") ? "<span class='badge bg-success'>Active</span>" : "<span class='badge bg-secondary'>Deactive</span>" ) + '</td>'
                            + '<td style="text-align:right">' 
                                + '<span onclick="editform(\''+data.ID+'\')" class="editLink"  title="Edit Record"><i class="fi fi-rs-pencil"></i></span>&nbsp;&nbsp;'
                                + '<span onclick="viewform(\''+data.ID+'\')" class="viewLink"  title="View Record"><i class="fi fi-rs-web-test"></i></span>&nbsp;&nbsp;'
                                + '<span onclick="openDeleteConfirmation(\''+data.ID+'\',\'r\',\'macbel\',\''+data.BoardOfEducation+'\',\'l\')" class="deleteLink" title="Delete Record"><i class="fi fi-rs-trash"></i></span>'
                            + '</td>'
                          + '</tr>'
                      + '</tr>';
                i++;
            });
            if(obj.data.length==0){
            html += '<tr>'
                + '<td colspan="5" style="text-align: center;background:#fff !important">No data found</td>'
                + '</tr>'
            }   
            $('#tbl_content').html(html);
        } else {
             $('#popupcontent').html( error(obj.message));
        }  
    });
}

setTimeout("list()",2000);

function addform(){
$('#confirmationtoadd').modal("show");  
   
$('#DocumentType').val("0"); 
$('#DocumentTitle').val(""); 


$('#ErrDocumentType').html(""); 
$('#ErrDocumentTitle').html(""); 
  
$("#DocumentType").removeClass("highlight_error");
$("#DocumentTitle").removeClass("highlight_error"); 
    
} 



 function confirmationtoSubmit(){
    var error = 0;
      if ($('#DocumentType').val()=="0"){
            $('#ErrDocumentType').html("Please select Document Type");
         $("#DocumentType").addClass("highlight_error");
          error++;
    }  else {
        $("#DocumentType").removeClass("highlight_error");
            $('#ErrDocumentType').html(""); 
    } 
    if ($('#DocumentTitle').val()==""){
            $('#ErrDocumentTitle').html("Please enter Document Title");
         $("#DocumentTitle").addClass("highlight_error");
          error++;
    }  else {
        $("#DocumentTitle").removeClass("highlight_error");
            $('#ErrDocumentTitle').html(""); 
    }
  
    
  
    if(error==0){
        $('#confirmationtoadd').modal("hide"); 
             $('#Success').modal("show");
      /*  var param = $('#frm_create').serialize();
        $.post(URL+"webservice.php?action=a&method=maigl",param,function(data){
        var obj = JSON.parse(data); 
        if (obj.status=="success") {
             $('#confirmationtoadd').modal("hide"); 
             $('#Success').modal("show");    
        }   else {
            if (obj.div=="") {
                $('#ErrCommon').html(print_inlineError(obj.message));
            } else {
                $('#Err'+obj.div).html(obj.message);   
            }
        }
    });*/
   } 
   
}

document.querySelectorAll(".drop-zone__input").forEach((inputElement) => {
  const dropZoneElement = inputElement.closest(".drop-zone");

  dropZoneElement.addEventListener("click", (e) => {
    inputElement.click();
  });

  inputElement.addEventListener("change", (e) => {
    if (inputElement.files.length) {
      updateThumbnail(dropZoneElement, inputElement.files[0]);
    }
  });

  dropZoneElement.addEventListener("dragover", (e) => {
    e.preventDefault();
    dropZoneElement.classList.add("drop-zone--over");
  });

  ["dragleave", "dragend"].forEach((type) => {
    dropZoneElement.addEventListener(type, (e) => {
      dropZoneElement.classList.remove("drop-zone--over");
    });
  });

  dropZoneElement.addEventListener("drop", (e) => {
    e.preventDefault();

    if (e.dataTransfer.files.length) {
      inputElement.files = e.dataTransfer.files;
      updateThumbnail(dropZoneElement, e.dataTransfer.files[0]);
    }

    dropZoneElement.classList.remove("drop-zone--over");
  });
});

/**
 * Updates the thumbnail on a drop zone element.
 *
 * @param {HTMLElement} dropZoneElement
 * @param {File} file
 */
function updateThumbnail(dropZoneElement, file) {
  let thumbnailElement = dropZoneElement.querySelector(".drop-zone__thumb");

  // First time - remove the prompt
  if (dropZoneElement.querySelector(".drop-zone__prompt")) {
    dropZoneElement.querySelector(".drop-zone__prompt").remove();
  }

  // First time - there is no thumbnail element, so lets create it
  if (!thumbnailElement) {
    thumbnailElement = document.createElement("div");
    thumbnailElement.classList.add("drop-zone__thumb");
    dropZoneElement.appendChild(thumbnailElement);
  }

  thumbnailElement.dataset.label = file.name;

  // Show thumbnail for image files
  if (file.type.startsWith("image/")) {
    const reader = new FileReader();

    reader.readAsDataURL(file);
    reader.onload = () => {
      thumbnailElement.style.backgroundImage = `url('${reader.result}')`;
    };
  } else {
    thumbnailElement.style.backgroundImage = null;
  }
}

                                                 
</script>
     